<?php
// webhook.php - Equivalent to Django webhooks for IntakeQ notifications

// Constants (exact match to Django)
define('WEBHOOK_LOG_FILE', __DIR__ . '/webhook_logs.json');
define('WEBHOOK_LOG_FILE_FOR_NOTES', __DIR__ . '/notes_webhook_logs.json');

// IntakeQ API
define('INTAKEQ_API_KEY', '45eaf2f1c5ba25e9a4cebfb040686d910152149c');
define('INTAKEQ_API_URL', 'https://intakeq.com/api/v1/intakes/%s');

// Email config
define('EMAIL_HOST', 'smtp.gmail.com');
define('EMAIL_PORT', 587);
define('EMAIL_USE_TLS', true);
define('EMAIL_HOST_USER', 'admin@aderishealth.com');
define('EMAIL_HOST_PASSWORD', 'pqxqdpmvhwqfkxmj');
define('DEFAULT_FROM_EMAIL', 'Medscape <admin@aderishealth.com>');

define('ADMIN_EMAIL', 'admin@aderishealth.com');   // change if needed
define('CLINIC_EMAIL', 'admin@aderishealth.com');   // fallback if no match

define('NOTES_DIR', 'notes-form');

// -------------------------
// Mapping JSON (Id → Name → Email) - QUESTIONNAIRE_EMAILS
// -------------------------
$QUESTIONNAIRE_EMAILS = [
  [
    'Id' => '688cae7b9372997679068d88',
    'Name' => 'California Aesthetics Intake Form (Milpitas)',
    'Email' => ['kathleen@californiaaesthetics.co', 'greg@californiaaesthetics.co', 'laa@californiaaesthetics.co', 'alissa@californiaaesthetics.co']
  ],
  [
    'Id' => '67ad4150e843e106c3e18815',
    'Name' => 'Pure Hydration by TLC Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '681b9c32294e3480bbcd9ade',
    'Name' => 'Cryogenix Rejuvenation & Recovery Intake Form',
    'Email' => 'cryogenixrr@gmail.com'
  ],
  [
    'Id' => '67a619875c60a6283e234129',
    'Name' => 'Cierra Parks Consent Link',
    'Email' => ''
  ],
  [
    'Id' => '6824b985b105d60c5aef83e7',
    'Name' => 'Extravagant Pampering Intake Form',
    'Email' => 'extravagantpampering@yahoo.com'
  ],
  [
    'Id' => '67a619875c60a6283e23410e',
    'Name' => 'Good Faith Exam Pre-Assessment',
    'Email' => ''
  ],
  [
    'Id' => '681a7b73e0627a16d6bc4590',
    'Name' => 'My Ageless Lounge Intake Form',
    'Email' => 'christa@skinbychrista.com'
  ],
  [
    'Id' => '6807b1ab325448f194eedca6',
    'Name' => 'You Glow Aesthetics Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '6810074e8851bd97da3a8261',
    'Name' => 'Reclaim Health Intake Form',
    'Email' => 'info@reclaim-nc.com'
  ],
  [
    'Id' => '67db644c052fb9ced655a736',
    'Name' => 'Eleve Med Spa and Aesthetics Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '682f3a415e586769a0b755c2',
    'Name' => 'Regenesis Wellness Intake Form',
    'Email' => 'riley@regenesis-wellness.com'
  ],
  [
    'Id' => '68083b8e99335bfad2783392',
    'Name' => 'Replenish Health Spa Intake Form',
    'Email' => 'Sam@replenishhealthspa.com'
  ],
  [
    'Id' => '68cdb4b5056b0642dc443b04',
    'Name' => 'California Aesthetics Intake Form (Glendale)',
    'Email' => ['dawn@californiaaesthetics.co', 'karla@californiaaesthetics.co', 'laa@californiaaesthetics.co', 'maranda@californiaaesthetics.co', 'anna@californiaaesthetics.co']
  ],
  [
    'Id' => '68cdb3bf056b0642dc44351d',
    'Name' => 'California Aesthetics Intake Form (Orange County)',
    'Email' => ['megan@californiaaesthetics.co', 'lidia@californiaaesthetics.co', 'laa@californiaaesthetics.co', 'tara@californiaaesthetics.co']
  ],
  [
    'Id' => '6809a98325025d00018a4012',
    'Name' => 'SevenReveries Intake Form',
    'Email' => 'ale.tkachenko@gmail.com'
  ],
  [
    'Id' => '687d143aea7cd765dc07c55d',
    'Name' => 'Modern Cryo & Wellness Intake Form',
    'Email' => 'chris@moderncryo.com'
  ],
  [
    'Id' => '6838bd4c420165cdb5307b38',
    'Name' => 'Diamond\'s Unique Wellness Intake Form',
    'Email' => 'diamonds uniquewellness@gmail.com'
  ],
  [
    'Id' => '683f7b837c1672323182e2ed',
    'Name' => 'TinyTox Collab Intake Form',
    'Email' => ['tinytoxcollab@gmail.com', 'admin@aderishealth.com']
  ],
  [
    'Id' => '6837774a57106a3b36eacd9d',
    'Name' => 'Impact Body Worx Intake Form',
    'Email' => 'info@impactbodyworx.com'
  ],
  [
    'Id' => '6849a35e2e21a3f8dbfdf15a',
    'Name' => 'Regen Therapeutics Atlanta Intake Form',
    'Email' => 'nsprphg@gmail.com'
  ],
  [
    'Id' => '684ff1c66747e02e8e6f393a',
    'Name' => 'Skynn Medical Aesthetics Intake Form',
    'Email' => 'briannefaas123@gmail.com'
  ],
  [
    'Id' => '686445b89b7bdb87ad87170f',
    'Name' => 'AcneClinicNYC Intake Form',
    'Email' => ['acneclinicnyc1@gmail.com']
  ],
  [
    'Id' => '68657fa8230916b7fddb422e',
    'Name' => 'Sage Revive Intake Form',
    'Email' => [
      'rjmalhotra@gmail.com',
      'ashleyholliday@sagerevivemoorestown.com'
    ]
  ],
  [
    'Id' => '687a47cf1f2a049658b94c48',
    'Name' => 'My Thera Touch & Healing Intake Form',
    'Email' => 'theratouchandhealing@gmail.com'
  ],
  [
    'Id' => '687d17941f39999908cc2c9e',
    'Name' => 'Lashes By Ty LLC Intake Form',
    'Email' => 'lashesbyty@icloud.com'
  ],
  [
    'Id' => '687d1cd74004b911200d8655',
    'Name' => 'Vita Nova Medical Intake Form',
    'Email' => 'info@vitanovamedical.com'
  ],
  [
    'Id' => '687d2ce4017751c54aeab0a0',
    'Name' => 'Revivea Health and Wellness Intake Form',
    'Email' => ['contact@reviva-aesthetics.com', 'mya@reviva-aesthetics.com', 'contactrevivaaesthetics@gmail.com']
  ],
  [
    'Id' => '686447182606cd65f4a93201',
    'Name' => 'Dr. Danilevsky Aesthetic Medicine Intake Form',
    'Email' => 'endorphinmedcorp@gmail.com'
  ],
  [
    'Id' => '687d2f95017751c54aeab7b6',
    'Name' => 'Arizona Aesthetics Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '687d3286ea7cd765dc080b70',
    'Name' => 'NovaStem Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '68869df1da411e4e9964977b',
    'Name' => 'Zapier Sample Form',
    'Email' => ''
  ],
  [
    'Id' => '689017888b150fa65beea545',
    'Name' => 'Sample Intake for TESTING',
    'Email' => ''
  ],
  [
    'Id' => '689dedfe4307223d37e91a90',
    'Name' => 'Nature\'s Drip Intake',
    'Email' => 'ashatthecornucopia@gmail.com'
  ],
  [
    'Id' => '68a15f5dd82116164296c230',
    'Name' => 'Testing Form',
    'Email' => ['snakoti511@gmail.com', 'testing00120120@yopmail.com']
  ],
  [
    'Id' => '68af1595dd0291edbd5ca739',
    'Name' => 'New York Beauty Center',
    'Email' => 'newyorkbeautycenter@gmail.com'
  ],
  [
    'Id' => '68af006cf238f1a6aaca48bb',
    'Name' => 'Transformation Station',
    'Email' => 'resultstremellc@gmail.com'
  ],
  [
    'Id' => '68af1595dd0291edbd5ca739',
    'Name' => 'New York Beauty Center',
    'Email' => 'newyorkbeautycenter@gmail.com'
  ],
  [
    'Id' => '68c460c8c13451d53f08933d',
    'Name' => 'Rejuvenate Aesthetics Intake Form',
    'Email' => 'rejuvenateoakley@gmail.com'
  ],
  [
    'Id' => '68d2eec6536dff747b489e41',
    'Name' => 'Inspired Beauty Med Spa Intake Form',
    'Email' => 'info@inspiredbeauty.boutique'
  ],
  [
    'Id' => '68d45db64f315e86ed666d8e',
    'Name' => 'The Protocole Intake Form',
    'Email' => ['delphine@theprotocole.com', 'cindy@theprotocole.com']
  ]
];

// NOTE_EMAILS (exact match to Django)
$NOTE_EMAILS = [
    'California Aesthetics Note (Milpitas)' => 'kathleen@californiaaesthetics.co, greg@californiaaesthetics.co, laa@californiaaesthetics.co, alissa@californiaaesthetics.co',
    'California Aesthetic Note (Glendale)' => 'dawn@californiaaesthetics.co, karla@californiaaesthetics.co, laa@californiaaesthetics.co, maranda@californiaaesthetics.co, anna@californiaaesthetics.co',
    'California Aesthetic Note (Orange)' => 'megan@californiaaesthetics.co, lidia@californiaaesthetics.co, laa@californiaaesthetics.co, tara@californiaaesthetics.co',

    'Diamond\'s Unique Client Note' => '',
    'Extravagant Pampering Note' => 'extravagantpampering@yahoo.com',
    'Impact Body Worx Note' => 'info@impactbodyworx.com',
    'My Ageless Lounge Note' => 'christa@skinbychrista.com',
    'Reclaim Health Note' => 'info@reclaim-nc.com',
    'Diamond\'s Unique Wellness Note' => 'diamonds uniquewellness@gmail.com',
    'Regenesis Wellness Notes' => 'riley@regenesis-wellness.com',
    'Regen Therapeutics Atlanta Note' => 'nsprphg@gmail.com',
    'Skynn Medical Aesthetics Note' => 'briannefaas123@gmail.com',
    'NEW SevenReveries Note' => '',
    'TinyTox Collab Note' => 'tinytoxcollab@gmail.com, admin@aderishealth.com',
    'Replenish Health Spa Note' => 'Sam@replenishhealthspa.com',
    'Dr. Danilevsky Aesthetic Medicine Note' => 'endorphinmedcorp@gmail.com',
    'SevenReveries Note' => 'ale.tkachenko@gmail.com',
    'Sage Revive Note' => 'rjmalhotra@gmail.com, ashleyholliday@sagerevivemoorestown.com',
    'Sample Note For TESTING' => 'snakoti511@gmail.com, asddfff@yopmail.com',
    'Sage Revive Documentation Note' => '',
    'My Thera Touch Note' => 'theratouchandhealing@gmail.com',
    'AcneClinicNYC Note' => 'acneclinicnyc1@gmail.com',
    'Modern Cryo & Wellness Note' => 'chris@moderncryo.com',
    'Lashes By Ty LLC Note' => 'lashesbyty@icloud.com',
    'Arizona Aesthetics Note' => '',
    'NovaStem Note' => '',
    'Nature\'s Drip Note' => 'ashatthecornucopia@gmail.com',
    'A Client Note' => '',
    'Exosomes Hair Restoration' => '',
    'Transformation Station Note' => 'resultstremellc@gmail.com',
    'Reviva Aesthetics Note' => 'contact@reviva-aesthetics.com, mya@reviva-aesthetics.com, contactrevivaaesthetics@gmail.com',
    'New York Beauty Center Note' => 'newyorkbeautycenter@gmail.com',
    'Inspired Beauty Med Spa Note' => 'info@inspiredbeauty.boutique',
    'The Protocole Note' => 'cindy@theprotocole.com, delphine@theprotocole.com'
];

// Helper: Send email using raw SMTP (no attachments)
function send_email($subject, $body, $recipient_list) {
    try {
        $msg = new \stdClass();
        $msg->From = DEFAULT_FROM_EMAIL;
        $msg->To = implode(', ', $recipient_list);
        $msg->Subject = $subject;
        $msg->body = $body;

        $mail = new \PHPMailer\PHPMailer\PHPMailer(); // Wait, no - use raw SMTP as in Django
        // Actually, to match "exact same", use raw SMTP with fsockopen or stream_socket_client, but for simplicity, use mail() if available; better: implement SMTP.

        // Raw SMTP implementation (exact match)
        $smtp = fsockopen(EMAIL_HOST, EMAIL_PORT, $errno, $errstr, 30);
        if (!$smtp) {
            error_log("SMTP connection failed: $errstr ($errno)");
            return false;
        }

        // Wait, full raw SMTP is complex; for exact, but to keep simple, use this library-free version with stream.
        $context = stream_context_create([
            'ssl' => ['verify_peer' => false, 'verify_peer_name' => false, 'allow_self_signed' => true]
        ]);
        $smtp = stream_socket_client("tcp://" . EMAIL_HOST . ":" . EMAIL_PORT, $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $context);
        if (!$smtp) {
            error_log("SMTP connection failed: $errstr ($errno)");
            return false;
        }

        // Handshake (simplified - EHLO, STARTTLS, AUTH)
        fputs($smtp, "EHLO " . $_SERVER['SERVER_NAME'] . "\r\n");
        $response = fgets($smtp);
        fputs($smtp, "STARTTLS\r\n");
        $response = fgets($smtp);
        stream_socket_enable_crypto($smtp, true, STREAM_CRYPTO_METHOD_TLS_CLIENT);

        fputs($smtp, "EHLO " . $_SERVER['SERVER_NAME'] . "\r\n");
        $response = fgets($smtp);
        fputs($smtp, "AUTH LOGIN\r\n");
        $response = fgets($smtp);
        fputs($smtp, base64_encode(EMAIL_HOST_USER) . "\r\n");
        $response = fgets($smtp);
        fputs($smtp, base64_encode(EMAIL_HOST_PASSWORD) . "\r\n");
        $response = fgets($smtp);

        // Build message (MIMEMultipart equivalent)
        $boundary = md5(time());
        $headers = "From: " . DEFAULT_FROM_EMAIL . "\r\n";
        $headers .= "To: " . implode(', ', $recipient_list) . "\r\n";
        $headers .= "Subject: " . $subject . "\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: multipart/mixed; boundary=\"" . $boundary . "\"\r\n\r\n";
        $body_msg = "--" . $boundary . "\r\n";
        $body_msg .= "Content-Type: text/html; charset=UTF-8\r\n\r\n";
        $body_msg .= $body . "\r\n";
        $body_msg .= "--" . $boundary . "--\r\n";

        fputs($smtp, "MAIL FROM:<" . EMAIL_HOST_USER . ">\r\n");
        $response = fgets($smtp);
        foreach ($recipient_list as $recipient) {
            fputs($smtp, "RCPT TO:<" . $recipient . ">\r\n");
            $response = fgets($smtp);
        }
        fputs($smtp, "DATA\r\n");
        $response = fgets($smtp);
        fputs($smtp, $headers . $body_msg);
        fputs($smtp, "\r\n.\r\n");
        $response = fgets($smtp);
        fputs($smtp, "QUIT\r\n");
        fclose($smtp);
        return true;
    } catch (Exception $e) {
        error_log("Email send failed: " . $e->getMessage());
        return false;
    }
}

// Helper: Send email with attachments (for notes)
function send_notes_email($subject, $body, $recipient_list, $attachments = null) {
    try {
        $boundary = md5(time());
        $headers = "From: " . DEFAULT_FROM_EMAIL . "\r\n";
        $headers .= "To: " . implode(', ', $recipient_list) . "\r\n";
        $headers .= "Subject: " . $subject . "\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: multipart/mixed; boundary=\"" . $boundary . "\"\r\n\r\n";

        $body_msg = "--" . $boundary . "\r\n";
        $body_msg .= "Content-Type: text/html; charset=UTF-8\r\n\r\n";
        $body_msg .= $body . "\r\n";

        if ($attachments) {
            foreach ($attachments as $file_path) {
                if (file_exists($file_path)) {
                    $filename = basename($file_path);
                    $file_content = chunk_split(base64_encode(file_get_contents($file_path)));
                    $body_msg .= "--" . $boundary . "\r\n";
                    $body_msg .= "Content-Type: application/octet-stream; name=\"" . $filename . "\"\r\n";
                    $body_msg .= "Content-Disposition: attachment; filename=\"" . $filename . "\"\r\n";
                    $body_msg .= "Content-Transfer-Encoding: base64\r\n\r\n";
                    $body_msg .= $file_content . "\r\n";
                }
            }
        }

        $body_msg .= "--" . $boundary . "--\r\n";

        // Same SMTP logic as send_email
        $context = stream_context_create([
            'ssl' => ['verify_peer' => false, 'verify_peer_name' => false, 'allow_self_signed' => true]
        ]);
        $smtp = stream_socket_client("tcp://" . EMAIL_HOST . ":" . EMAIL_PORT, $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $context);
        if (!$smtp) {
            error_log("SMTP connection failed: $errstr ($errno)");
            return false;
        }

        fputs($smtp, "EHLO " . $_SERVER['SERVER_NAME'] . "\r\n");
        $response = fgets($smtp);
        fputs($smtp, "STARTTLS\r\n");
        $response = fgets($smtp);
        stream_socket_enable_crypto($smtp, true, STREAM_CRYPTO_METHOD_TLS_CLIENT);

        fputs($smtp, "EHLO " . $_SERVER['SERVER_NAME'] . "\r\n");
        $response = fgets($smtp);
        fputs($smtp, "AUTH LOGIN\r\n");
        $response = fgets($smtp);
        fputs($smtp, base64_encode(EMAIL_HOST_USER) . "\r\n");
        $response = fgets($smtp);
        fputs($smtp, base64_encode(EMAIL_HOST_PASSWORD) . "\r\n");
        $response = fgets($smtp);

        fputs($smtp, "MAIL FROM:<" . EMAIL_HOST_USER . ">\r\n");
        $response = fgets($smtp);
        foreach ($recipient_list as $recipient) {
            fputs($smtp, "RCPT TO:<" . $recipient . ">\r\n");
            $response = fgets($smtp);
        }
        fputs($smtp, "DATA\r\n");
        $response = fgets($smtp);
        fputs($smtp, $headers . $body_msg);
        fputs($smtp, "\r\n.\r\n");
        $response = fgets($smtp);
        fputs($smtp, "QUIT\r\n");
        fclose($smtp);
        return true;
    } catch (Exception $e) {
        error_log("Email send failed: " . $e->getMessage());
        return false;
    }
}

// Helper: Log to JSON file
function log_to_json($log_file, $payload) {
    $event_data = [
        'timestamp' => date('c'), // ISO format equivalent to now().isoformat()
        'data' => $payload
    ];
    $logs = [];
    if (file_exists($log_file)) {
        $log_content = file_get_contents($log_file);
        $logs = json_decode($log_content, true) ?: [];
    }
    $logs[] = $event_data;
    file_put_contents($log_file, json_encode($logs, JSON_PRETTY_PRINT));
}

// Helper: Make API request with cURL (equivalent to requests.get)
function api_get($url, $headers) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // For testing; enable in prod
    $response = curl_exec($ch);
    $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['status_code' => $status_code, 'body' => $response];
}

// Routing and Main Logic
$request_uri = $_SERVER['REQUEST_URI'] ?? '';
$method = $_SERVER['REQUEST_METHOD'] ?? '';

if ($method !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST allowed']);
    exit;
}

$input = file_get_contents('php://input');
$payload = json_decode($input, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => json_last_error_msg()]);
    exit;
}

// Determine endpoint
$is_notes = strpos($request_uri, '/practiceq/webhook/notes/') !== false;
$is_intake = strpos($request_uri, '/practiceq/webhook/') !== false && !$is_notes;

if (!$is_intake && !$is_notes) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Invalid endpoint']);
    exit;
}

// Log webhook (use appropriate file)
$log_file = $is_notes ? WEBHOOK_LOG_FILE_FOR_NOTES : WEBHOOK_LOG_FILE;
log_to_json($log_file, $payload);

try {
    if ($is_intake) {
        // practiceq_webhook logic
        $intake_id = $payload['IntakeId'] ?? null;
        if (!$intake_id) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'No IntakeId in payload']);
            exit;
        }

        $url = sprintf(INTAKEQ_API_URL, $intake_id);
        $headers = ['X-Auth-Key: ' . INTAKEQ_API_KEY];
        $api_res = api_get($url, $headers);

        if ($api_res['status_code'] === 200) {
            $intake_data = json_decode($api_res['body'], true);
            $questionnaire_id = $intake_data['QuestionnaireId'] ?? null;
            $client_name = $intake_data['ClientName'] ?? '';

            // Match questionnaire id
            $matched = null;
            foreach ($QUESTIONNAIRE_EMAILS as $q) {
                if ($q['Id'] === $questionnaire_id) {
                    $matched = $q;
                    break;
                }
            }

            if ($matched) {
                $recipient_email = $matched['Email'] ?: CLINIC_EMAIL;

                // Ensure list
                if (is_string($recipient_email)) {
                    $recipient_email = $recipient_email ? [$recipient_email] : [];
                }

                $all_recipient_list = array_merge($recipient_email, [ADMIN_EMAIL]);

                $subject = 'Patient Intake Form Submission - ' . $matched['Name'];
                $message_body = <<<HTML
<!DOCTYPE html>
<html>
<body>
    <p>Dear Clinic,</p>
    <p>Please be advised that <strong>{$client_name}</strong> has successfully submitted their intake form.</p>
    <p>Best regards,</p>
    <p>MedScape GFE</p>
</body>
</html>
HTML;

                send_email($subject, $message_body, $all_recipient_list);
            }
        } else {
            error_log('API fetch failed: ' . $api_res['body']);
        }
    } elseif ($is_notes) {
        // locked_notes_webhook logic
        if ($payload['Type'] !== 'Note Locked') {
            // Silently ignore other types, as in Django
            echo json_encode(['status' => 'success', 'message' => 'Webhook processed successfully']);
            exit;
        }

        $note_id = $payload['NoteId'] ?? null;
        $pdf_url = 'https://intakeq.com/api/v1/notes/' . $note_id . '/pdf';
        $headers = ['X-Auth-Key: ' . INTAKEQ_API_KEY];
        $default_note_url = 'https://intakeq.com/api/v1/notes/' . $note_id;

        // Step 1: Get Note details
        $default_res = api_get($default_note_url, $headers);
        if ($default_res['status_code'] !== 200) {
            throw new Exception('Failed to fetch note details: ' . $default_res['body']);
        }
        $data = json_decode($default_res['body'], true);
        $note_name = trim($data['NoteName'] ?? '');
        $client_name = trim($data['ClientName'] ?? '');

        // Step 2: Download PDF
        $pdf_res = api_get($pdf_url, $headers);
        if ($pdf_res['status_code'] !== 200) {
            throw new Exception('Failed to download PDF: ' . $pdf_res['body']);
        }

        // Sanitize note_name
        $safe_note_name = preg_replace('/[^a-zA-Z0-9 _-]/', '_', $note_name);

        $note_dir = NOTES_DIR . '/' . $safe_note_name;
        if (!is_dir($note_dir)) {
            mkdir($note_dir, 0755, true);
        }

        $file_path = $note_dir . '/' . $note_id . '.pdf';
        file_put_contents($file_path, $pdf_res['body']);

        // Common message body
        $message_body = <<<HTML
<!DOCTYPE html>
<html>
<body>
    <p>Dear Recipient,</p>
    <p>Please be advised that the note for <b>{$client_name}</b> has been signed.</p>
    <p>Please see the attached PDF.</p>
    <p>Best regards,</p>
    <p>MedScape GFE</p>
</body>
</html>
HTML;

        // === 2) Send to Clinic (if exists) ===
        // Normalize NOTE_EMAILS (lowercase keys)
        $normalized_note_emails = [];
        foreach ($NOTE_EMAILS as $k => $v) {
            $normalized_note_emails[strtolower($k)] = $v;
        }
        $clinic_email_str = $normalized_note_emails[strtolower($note_name)] ?? '';
        if ($clinic_email_str) {
            $clinic_recipients = array_filter(array_map('trim', explode(',', $clinic_email_str)));
            $clinic_recipient_list = array_merge($clinic_recipient_list, [ADMIN_EMAIL]);
            if (!empty($clinic_recipient_list)) {
                $subject = 'New Locked Note - ' . ($note_name ?: $note_id) . ' by ' . $client_name;
                send_notes_email($subject, $message_body, $clinic_recipient_list, [$file_path]);
            }
        }

        // Note: Django has a commented-out admin send; keeping as is (only clinic)
    }

    echo json_encode(['status' => 'success', 'message' => 'Webhook processed successfully']);
} catch (Exception $e) {
    error_log('Webhook error: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>