<?php
// inteq_form.php - Handles Intake Form Webhook (using PHPMailer for simplicity)
header('Content-Type: application/json');

// Include PHPMailer (via Composer)
require_once __DIR__ . '/vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Custom debug log file
define('DEBUG_LOG_FILE', __DIR__ . '/debug.log');

// Constants (exact match to original)
define('WEBHOOK_LOG_FILE', __DIR__ . '/webhook_logs.json');

// IntakeQ API
define('INTAKEQ_API_KEY', '45eaf2f1c5ba25e9a4cebfb040686d910152149c');
define('INTAKEQ_API_URL', 'https://intakeq.com/api/v1/intakes/%s');

// Email config
define('EMAIL_HOST', 'smtp.gmail.com');
define('EMAIL_PORT', 587);
define('EMAIL_USE_TLS', true);
define('EMAIL_HOST_USER', 'admin@aderishealth.com');
define('EMAIL_HOST_PASSWORD', 'pqxqdpmvhwqfkxmj');
define('DEFAULT_FROM_EMAIL', 'Medscape <admin@aderishealth.com>');

define('ADMIN_EMAIL', 'admin@aderishealth.com');   // change if needed
define('CLINIC_EMAIL', 'admin@aderishealth.com');   // fallback if no match

// -------------------------
// Mapping JSON (Id → Name → Email) - QUESTIONNAIRE_EMAILS
// -------------------------
$QUESTIONNAIRE_EMAILS = [
  [
    'Id' => '688cae7b9372997679068d88',
    'Name' => 'California Aesthetics Intake Form (Milpitas)',
    'Email' => ['kathleen@californiaaesthetics.co', 'greg@californiaaesthetics.co', 'laa@californiaaesthetics.co', 'alissa@californiaaesthetics.co']
  ],
  [
    'Id' => '67ad4150e843e106c3e18815',
    'Name' => 'Pure Hydration by TLC Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '681b9c32294e3480bbcd9ade',
    'Name' => 'Cryogenix Rejuvenation & Recovery Intake Form',
    'Email' => 'cryogenixrr@gmail.com'
  ],
  [
    'Id' => '67a619875c60a6283e234129',
    'Name' => 'Cierra Parks Consent Link',
    'Email' => ''
  ],
  [
    'Id' => '6824b985b105d60c5aef83e7',
    'Name' => 'Extravagant Pampering Intake Form',
    'Email' => 'extravagantpampering@yahoo.com'
  ],
  [
    'Id' => '67a619875c60a6283e23410e',
    'Name' => 'Good Faith Exam Pre-Assessment',
    'Email' => ''
  ],
  [
    'Id' => '681a7b73e0627a16d6bc4590',
    'Name' => 'My Ageless Lounge Intake Form',
    'Email' => 'christa@skinbychrista.com'
  ],
  [
    'Id' => '6807b1ab325448f194eedca6',
    'Name' => 'You Glow Aesthetics Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '6810074e8851bd97da3a8261',
    'Name' => 'Reclaim Health Intake Form',
    'Email' => 'info@reclaim-nc.com'
  ],
  [
    'Id' => '67db644c052fb9ced655a736',
    'Name' => 'Eleve Med Spa and Aesthetics Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '682f3a415e586769a0b755c2',
    'Name' => 'Regenesis Wellness Intake Form',
    'Email' => 'riley@regenesis-wellness.com'
  ],
  [
    'Id' => '68083b8e99335bfad2783392',
    'Name' => 'Replenish Health Spa Intake Form',
    'Email' => 'Sam@replenishhealthspa.com'
  ],
  [
    'Id' => '68cdb4b5056b0642dc443b04',
    'Name' => 'California Aesthetics Intake Form (Glendale)',
    'Email' => ['dawn@californiaaesthetics.co', 'karla@californiaaesthetics.co', 'laa@californiaaesthetics.co', 'maranda@californiaaesthetics.co', 'anna@californiaaesthetics.co']
  ],
  [
    'Id' => '68cdb3bf056b0642dc44351d',
    'Name' => 'California Aesthetics Intake Form (Orange County)',
    'Email' => ['megan@californiaaesthetics.co', 'lidia@californiaaesthetics.co', 'laa@californiaaesthetics.co', 'tara@californiaaesthetics.co']
  ],
  [
    'Id' => '6809a98325025d00018a4012',
    'Name' => 'SevenReveries Intake Form',
    'Email' => 'ale.tkachenko@gmail.com'
  ],
  [
    'Id' => '687d143aea7cd765dc07c55d',
    'Name' => 'Modern Cryo & Wellness Intake Form',
    'Email' => 'chris@moderncryo.com'
  ],
  [
    'Id' => '6838bd4c420165cdb5307b38',
    'Name' => 'Diamond\'s Unique Wellness Intake Form',
    'Email' => 'diamonds uniquewellness@gmail.com'
  ],
  [
    'Id' => '683f7b837c1672323182e2ed',
    'Name' => 'TinyTox Collab Intake Form',
    'Email' => ['tinytoxcollab@gmail.com', 'admin@aderishealth.com']
  ],
  [
    'Id' => '6837774a57106a3b36eacd9d',
    'Name' => 'Impact Body Worx Intake Form',
    'Email' => 'info@impactbodyworx.com'
  ],
  [
    'Id' => '6849a35e2e21a3f8dbfdf15a',
    'Name' => 'Regen Therapeutics Atlanta Intake Form',
    'Email' => 'nsprphg@gmail.com'
  ],
  [
    'Id' => '684ff1c66747e02e8e6f393a',
    'Name' => 'Skynn Medical Aesthetics Intake Form',
    'Email' => 'briannefaas123@gmail.com'
  ],
  [
    'Id' => '686445b89b7bdb87ad87170f',
    'Name' => 'AcneClinicNYC Intake Form',
    'Email' => ['acneclinicnyc1@gmail.com']
  ],
  [
    'Id' => '68657fa8230916b7fddb422e',
    'Name' => 'Sage Revive Intake Form',
    'Email' => [
      'rjmalhotra@gmail.com',
      'ashleyholliday@sagerevivemoorestown.com'
    ]
  ],
  [
    'Id' => '687a47cf1f2a049658b94c48',
    'Name' => 'My Thera Touch & Healing Intake Form',
    'Email' => 'theratouchandhealing@gmail.com'
  ],
  [
    'Id' => '687d17941f39999908cc2c9e',
    'Name' => 'Lashes By Ty LLC Intake Form',
    'Email' => 'lashesbyty@icloud.com'
  ],
  [
    'Id' => '687d1cd74004b911200d8655',
    'Name' => 'Vita Nova Medical Intake Form',
    'Email' => 'info@vitanovamedical.com'
  ],
  [
    'Id' => '687d2ce4017751c54aeab0a0',
    'Name' => 'Revivea Health and Wellness Intake Form',
    'Email' => ['contact@reviva-aesthetics.com', 'mya@reviva-aesthetics.com', 'contactrevivaaesthetics@gmail.com']
  ],
  [
    'Id' => '686447182606cd65f4a93201',
    'Name' => 'Dr. Danilevsky Aesthetic Medicine Intake Form',
    'Email' => 'endorphinmedcorp@gmail.com'
  ],
  [
    'Id' => '687d2f95017751c54aeab7b6',
    'Name' => 'Arizona Aesthetics Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '687d3286ea7cd765dc080b70',
    'Name' => 'NovaStem Intake Form',
    'Email' => ''
  ],
  [
    'Id' => '68869df1da411e4e9964977b',
    'Name' => 'Zapier Sample Form',
    'Email' => ''
  ],
  [
    'Id' => '689017888b150fa65beea545',
    'Name' => 'Sample Intake for TESTING',
    'Email' => ''
  ],
  [
    'Id' => '689dedfe4307223d37e91a90',
    'Name' => 'Nature\'s Drip Intake',
    'Email' => 'ashatthecornucopia@gmail.com'
  ],
  [
    'Id' => '68a15f5dd82116164296c230',
    'Name' => 'Testing Form',
    'Email' => ['snakoti511@gmail.com', 'testing00120120@yopmail.com']
  ],
  [
    'Id' => '68af1595dd0291edbd5ca739',
    'Name' => 'New York Beauty Center',
    'Email' => 'newyorkbeautycenter@gmail.com'
  ],
  [
    'Id' => '68af006cf238f1a6aaca48bb',
    'Name' => 'Transformation Station',
    'Email' => 'resultstremellc@gmail.com'
  ],
  [
    'Id' => '68af1595dd0291edbd5ca739',
    'Name' => 'New York Beauty Center',
    'Email' => 'newyorkbeautycenter@gmail.com'
  ],
  [
    'Id' => '68c460c8c13451d53f08933d',
    'Name' => 'Rejuvenate Aesthetics Intake Form',
    'Email' => 'rejuvenateoakley@gmail.com'
  ],
  [
    'Id' => '68d2eec6536dff747b489e41',
    'Name' => 'Inspired Beauty Med Spa Intake Form',
    'Email' => 'info@inspiredbeauty.boutique'
  ],
  [
    'Id' => '68d45db64f315e86ed666d8e',
    'Name' => 'The Protocole Intake Form',
    'Email' => ['delphine@theprotocole.com', 'cindy@theprotocole.com']
  ]
];

// Helper: Custom debug log to file
function debug_log($message) {
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[$timestamp] DEBUG (inteq_form.php): $message" . PHP_EOL;
    file_put_contents(DEBUG_LOG_FILE, $log_entry, FILE_APPEND | LOCK_EX);
}

// Helper: Send email using PHPMailer (no attachments)
function send_email($subject, $body, $recipient_list) {
    debug_log("send_email called with subject: $subject, recipients: " . implode(', ', $recipient_list));
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = EMAIL_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = EMAIL_HOST_USER;
        $mail->Password = EMAIL_HOST_PASSWORD;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = EMAIL_PORT;

        // Sender and recipients
        $mail->setFrom(EMAIL_HOST_USER, 'Medscape');
        foreach ($recipient_list as $recipient) {
            $mail->addAddress($recipient);
        }

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $body;

        $mail->send();
        debug_log("Email sent success");
        return true;
    } catch (Exception $e) {
        debug_log("Email failed: " . $mail->ErrorInfo);
        return false;
    }
}

// Helper: Log to JSON file - with explicit check
function log_to_json($log_file, $payload) {
    debug_log("log_to_json called for file: $log_file, payload: " . json_encode($payload));
    $event_data = [
        'timestamp' => date('c'), // ISO format equivalent to now().isoformat()
        'data' => $payload
    ];
    $logs = [];
    if (file_exists($log_file)) {
        $log_content = file_get_contents($log_file);
        if ($log_content !== false) {
            $logs = json_decode($log_content, true) ?: [];
            debug_log("Loaded existing logs, count: " . count($logs));
        } else {
            debug_log("file_get_contents failed for $log_file");
        }
    } else {
        debug_log("Log file $log_file does not exist, creating new");
    }
    $logs[] = $event_data;
    $write_result = file_put_contents($log_file, json_encode($logs, JSON_PRETTY_PRINT));
    if ($write_result === false) {
        debug_log("CRITICAL: file_put_contents FAILED for $log_file - check permissions!");
    } else {
        debug_log("Log written successfully, bytes: $write_result");
    }
}

// Helper: Make API request with cURL (equivalent to requests.get) - with debug
function api_get($url, $headers) {
    debug_log("api_get called for URL: $url");
    if (!function_exists('curl_init')) {
        debug_log("CRITICAL: cURL not enabled!");
        return ['status_code' => 0, 'body' => 'cURL missing'];
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // For testing; enable in prod
    $response = curl_exec($ch);
    $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);
    if ($curl_error) {
        debug_log("cURL error: $curl_error");
    }
    debug_log("API response status: $status_code, first 100 chars: " . substr($response, 0, 100));
    return ['status_code' => $status_code, 'body' => $response];
}

// Main Logic for inteq_form.php
debug_log("Script started, method: " . ($_SERVER['REQUEST_METHOD'] ?? 'NONE'));
$method = $_SERVER['REQUEST_METHOD'] ?? '';

if ($method !== 'POST') {
    debug_log("Non-POST method: $method");
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST allowed']);
    exit;
}

debug_log("POST detected, reading input");
$input = file_get_contents('php://input');
debug_log("Raw input length: " . strlen($input ?? ''));

$payload = json_decode($input, true);
$json_error = json_last_error();
if ($json_error !== JSON_ERROR_NONE) {
    debug_log("CRITICAL: JSON decode failed: " . json_last_error_msg());
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => json_last_error_msg()]);
    exit;
}

debug_log("Payload parsed: " . json_encode($payload));

// Log webhook - always
log_to_json(WEBHOOK_LOG_FILE, $payload);

try {
    debug_log("Try block entered");
    $intake_id = $payload['IntakeId'] ?? null;
    debug_log("IntakeId: " . ($intake_id ?? 'MISSING'));
    if (!$intake_id) {
        debug_log("No IntakeId, returning 400");
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'No IntakeId in payload']);
        exit;
    }

    $url = sprintf(INTAKEQ_API_URL, $intake_id);
    $headers = ['X-Auth-Key: ' . INTAKEQ_API_KEY];
    $api_res = api_get($url, $headers);

    if ($api_res['status_code'] === 200) {
        debug_log("API success, parsing data");
        $intake_data = json_decode($api_res['body'], true);
        $questionnaire_id = $intake_data['QuestionnaireId'] ?? null;
        $client_name = $intake_data['ClientName'] ?? '';
        debug_log("QuestionnaireId: $questionnaire_id, Client: $client_name");

        // Match questionnaire id
        $matched = null;
        foreach ($QUESTIONNAIRE_EMAILS as $q) {
            if ($q['Id'] === $questionnaire_id) {
                $matched = $q;
                break;
            }
        }
        debug_log("Matched questionnaire: " . ($matched ? $matched['Name'] : 'NO MATCH'));

        if ($matched) {
            $recipient_email = $matched['Email'] ?: CLINIC_EMAIL;
            debug_log("Recipient email raw: " . print_r($recipient_email, true));

            // Ensure list
            if (is_string($recipient_email)) {
                $recipient_email = $recipient_email ? [$recipient_email] : [];
            }

            $all_recipient_list = array_merge($recipient_email, [ADMIN_EMAIL]);
            debug_log("Final recipients: " . implode(', ', $all_recipient_list));

            $subject = 'Patient Intake Form Submission - ' . $matched['Name'];
            $message_body = <<<HTML
<!DOCTYPE html>
<html>
<body>
    <p>Dear Clinic,</p>
    <p>Please be advised that <strong>{$client_name}</strong> has successfully submitted their intake form.</p>
    <p>Best regards,</p>
    <p>MedScape GFE</p>
</body>
</html>
HTML;
            debug_log("Calling send_email");
            $email_sent = send_email($subject, $message_body, $all_recipient_list);
            debug_log("Email sent: " . ($email_sent ? 'YES' : 'NO'));
        } else {
            debug_log("No match, skipping email");
        }
    } else {
        debug_log('API fetch failed: ' . $api_res['body']);
    }

    debug_log("Returning success");
    echo json_encode(['status' => 'success', 'message' => 'Webhook processed successfully']);
} catch (Exception $e) {
    debug_log('Exception in try: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>